unit fROR_ICR;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fROR_GenericRegistry, Menus, ActnList, ImgList, StdCtrls,
  ComCtrls, ExtCtrls, Buttons, ToolWin, fROR_VistARegistries,
  fROR_ICRPatientEdit, ovcbase, ovcstate, ovcfiler, ovcstore,
  uROR_VistAStore, uROR_Selector, uROR_CustomControls,
   uROR_GridView, uROR_CustomListView, HTMLLite, AdvMenus, uROR_SearchEdit,
  AdvMenuStylers, VA508AccessibilityManager;

type
  TFormICR = class(TFormGenericRegistry)
    mnuPatients: TAdvPopupMenu;
    mnuCDC1: TMenuItem;
    Edit1: TMenuItem;
    N4: TMenuItem;
    Delete1: TMenuItem;
    acCDC: TAction;
    mnuCDC: TMenuItem;
    OvcComponentState: TOvcComponentState;
    btnPatientCDC: TBitBtn;
    procedure acHelpTopicsExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure acCDCExecute(Sender: TObject);
    procedure acEditPatientDataExecute(Sender: TObject);
    procedure lsvPatientsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
    bReadOnly: Boolean;

  protected
    function  GetLayoutSectionName: String; override;
    procedure SwitchActivePatient(anItem: TCCRGridItem); override;

  public
    constructor CreateRegistry(aRegInfo: TRegistryInfo; anOwner: TComponent = nil); override;

  end;

var
  FormICRPatientEdit: TFormICRPatientEdit;

implementation
{$R *.dfm}

uses
  uROR_ICRPatientData, uROR_Common, uROR_Errors, uROR_Broker,
  fROR_CDCList, uROR_Utilities, fROR_Main, uROR_Strings;

/////////////////////////////// ICR Registry Form \\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TFormICR.CreateRegistry(aRegInfo: TRegistryInfo; anOwner: TComponent);
begin
  inherited CreateRegistry(aRegInfo, anOwner);
  bReadOnly := True;

  if Assigned(RegInfo) then
    begin
      RegInfo.InvestDrugClasses.Add('IN150');
      ActivePatientData := TICRPatientData.Create(aRegInfo.IEN);
      if RegInfo.Admin then mnuCDC.Visible := True;
      LoadLayout;
    end;
end;

procedure TFormICR.acHelpTopicsExecute(Sender: TObject);
begin
  inherited;
  Application.HelpCommand(HELP_INDEX, 0);
end;

procedure TFormICR.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveLayout;
  inherited;
end;

function TFormICR.GetLayoutSectionName: String;
begin
  if Assigned(OvcComponentState) then
    Result := OvcComponentState.Section
  else
    Result := inherited GetLayoutSectionName;
end;

/////////////////////////////////// Registry \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFormICR.acCDCExecute(Sender: TObject);
var
  sList: TStringList;
  lockerr: TLockError;
  mrc: TReturnCode;
begin
  if not SetPatientContext then
    Exit;
  Broker.CreateResults;

  StartPatientEdit;
  try
    if bReadOnly then
      begin
        if MessageDlg508('', rscReadOnly + #13#13 + rscContinueRO,
          mtConfirmation, [mbYes,mbNo], 0) <> mrYes then Exit;
      end
    else
      begin
        if Broker.CallProc(rpcCDCLoad, [RegInfo.IEN, PtIEN, '1']) then
          begin
            bReadOnly := False;
            if Piece(Broker.Results[0], '^') <> '0' then // record is locked
              begin
                bReadOnly := True;
                lockerr := TLockError.Create(Broker.Results[0], 'CDC data');
                try
                  mrc := lockerr.Show;
                finally
                  lockerr.Free;
                end;
                if mrc = RCW_CANNOT_LOCK then Exit;
              end;
          end
        else
          begin
            MessageDlg508('', 'Cannot load patient CDC data', mtError, [mbOK], 0);
            Exit;
          end;
      end;

    if not Assigned(FormCDC) then
      begin
        sList := TStringList.Create;
        sList.Assign(Broker.Results);
        FormCDC := TFormCDC.Create(Application);
        Broker.Results.Assign(sList);
        sList.Free;
      end;

    FormCDC.SetUpForm(RegInfo.IEN, PtIEN, bReadOnly, Broker.Results);
    FormCDC.ShowModal;

    Broker.CallProc(rpcCDCCancel, [RegInfo.IEN,PtIEN]);
  finally
    EndPatientEdit;
  end;
end;

procedure TFormICR.acEditPatientDataExecute(Sender: TObject);
var
  edRC: TReturnCode;
begin
  edRC := RC_OK;
  if not Assigned(FormICRPatientEdit) then
    FormICRPatientEdit := TFormICRPatientEdit.Create(RegInfo);
  if SetPatientContext then
    begin
      StartPatientEdit;
      try
        edRC := FormICRPatientEdit.Edit(ActivePatientData, PtIEN);
        inherited;
      finally
        EndPatientEdit;
      end;
    end;
  if edRC = RC_DELETE then
    acDeletePatient.Execute;
end;

procedure TFormICR.lsvPatientsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_Return then
    if ssCtrl in Shift then
      acCDC.Execute
    else
      acEditPatientData.Execute;
end;

procedure TFormICR.SwitchActivePatient(anItem: TCCRGridItem);
var
  flags: String;
begin
  inherited;
  if Assigned(anItem) then
    begin
      flags := anItem.AsString[iPtlFlags];
      acCDC.Enabled := Pos('C', flags) <> 0;
      bReadOnly     := Pos('O', flags) <> 0;
    end
  else
    begin
      acCDC.Enabled := False;
      bReadOnly     := False;
    end;
end;

end.
